
   ; this routine is very similar to the --rolling ball-- shown in Jeffery P sanders web page


(defun c:66 ()
   (setvar "cmdecho" 0)
   (setq obj1 (car (entsel)))
   (setq w1 (vlax-ename->vla-object obj1))

   (setq obj2 (car (entsel)))
   (setq w2 (vlax-ename->vla-object obj2))

   (while T

      (setq cont 1)

      (while (= cont 1)
         (setq x (grread T 2 0))
         (if (= (car x) 5)
            (progn
               (setq worigin (nth 1 x))
               (setq pw1 (vlax-curve-getclosestpointto w1 worigin))
               (setq pw2 (vlax-curve-getclosestpointto w2 worigin))
               (setq
                  mid
                    (polar pw1 (angle pw1 pw2) (/ (distance pw1 pw2) 2))
               )
               (setq rad (distance mid pw1))
               (command "regen")
               (setq angulo (/ pi 17))
               (setq wang angulo)
               (setq wpt1 (polar mid 0 rad))
               (setq wpt2 (polar mid wang rad))
               (if (> rad 1)
                  (progn
                     (repeat 35
                        (grdraw wpt1 wpt2 -1)
                        (setq wpt1 wpt2)
                        (setq wpt2 (polar mid wang rad))
                        (setq wang (+ wang angulo))
                     )
                  )
               )
               )
            (setq cont 0)
         )
      )
      (command "circle" mid pw1)      
   )
)


; this routine makes a dynamic grid with vector arrows updating everytime the cursor is moved.

(defun c:55 ()
   (setq cly (getvar "clayer"))
   (setq arlist nil)
   (command "cmdecho" "0")
   (command "_undo" "_g")
   (command "cecolor" "2")
   (command "osmode" "33" "orthomode" "0" "clayer" "0")
   (setq p1 (getpoint "\n Select lower left point:"))
   (setq square (getint "\n enter number of array <12>:"))
   (if (= square nil)
      (setq square 12)
   )
   (setq nx square)
   (setq ny square)
   (command "osmode" "0")
   (setq hcount 0)
   (setq vcount 0)
   (setq wp p1)
   (while (< vcount square)
      (while (< hcount square) 
         (setq arlist (cons wp arlist))
         (setq wp (polar wp 0 1))
         (setq hcount (+ hcount 1))
      )
      (setq wp (polar p1 (/ pi 2) (+ vcount 1)))
      (setq vcount (+ vcount 1))
      (setq hcount 0)
   )
   (command "cecolor" "1")
   (setq tarp (getpoint "\n enter target point:"))
   (setq maxd (* square 1.0)) ;4142))
   (setq cc 0)
   (setq lenlis (length arlist))
   (setq cont 1)
   (while (= cont 1)
      (setq x (grread T 2 0))
      (if (= (car x) 5)
         (progn
            (setq tarp (cadr x))
            (setq cc 0)
            (command "regen")
            (repeat lenlis
               (setq wdis (distance tarp (nth cc arlist)))
               (setq wdis (* wdis 150.0))
               (setq wcol (/ wdis maxd))
               (setq wpp (nth cc arlist))
               (setq wang (angle wpp tarp))
               (setq pt1 (polar wpp (- wang (/ pi 2)) 0.5))  
               (setq pt2 (polar wpp (+ wang (/ pi 2)) 0.5))
               (grdraw pt1 pt2 (fix wcol)) ; this can have -1 for vector but would be cyan
               (setq cc (+ cc 1))
            )
         )
         (setq cont 0)
      )
   )
   (command "_undo" "_e")
)



;;;  
;|Visual LISP Format Options
(72 3 3 2 nil "end of " 60 9 0 0 0 nil T nil T)
;*** DO NOT add text below the comment! ***|;
