
(defun c:puzzle ()
   (setq cly (getvar "clayer"))
   (command "undo" "g")
   (command "highlight" "0")
   (command "cursorsize" "2")
   (command "imageframe" "on")
   (setq c 1)
   (setq centers nil)
   (setq areal nil)
   (command "osmode" "33" "orthomode" "0" "clayer" "0" "cmdecho" "0")
   (setq p1 (getpoint "\n Select lower left corner:"))
   (setq p3 (getpoint "\n Select upper right corner:"))
   (setq level (getint "\n Enter difficulty level 1, 2, 3, 4, 5:"))
   (command "osmode" "0")
   (if (= level 1)
      (setq div 3)
   )
   (if (= level 2)
      (setq div 4)
   )
   (if (= level 3)
      (setq div 5)
   )
   (if (= level 4)
      (setq div 6)
   )
   (if (= level 5)
      (setq div 7)
   )
   (if (or (= level nil) (> level 5))
      (setq div 5)
   )
   (setq nx 0)
   (setq ny 1)
   (setq p2 (list (car p3) (cadr p1)))
   (setq p4 (list (car p1) (cadr p3)))
   (setq dhor (distance p1 p2))
   (setq dver (distance p1 p4))
   (setq wv (/ dver div))
   (setq wh (/ dhor div))
   (setq mmin (min wv wh))
   (setq cir (/ mmin 4))
   (setq pivot (polar p1 0 (+ dhor (/ dhor 2))))
   (setq disp (+ dhor (/ dhor 2)))
   (setq dd (strcat "@" (rtos disp 2 6) ",0,0"))
   (setq f1 pivot)
   (setq f2 (polar f1 0 wh))
   (setq f3 (polar f2 (/ pi 2) wv))
   (setq f4 (polar f3 pi wh))
   (setq cen (inters f1 f3 f2 f4))
   (setq areain (list (car f1) (car f3) (cadr f1) (cadr f3)))
   (setq zm1 (polar p1 0 (* 3 dhor)))
   (setq zm2 (polar zm1 (/ pi 2) dver))
   (command "zoom" p1 zm2)
   (while (<= ny div)
      (while (< nx div)
         (command "copy" "c" p1 p2 "" "0,0,0" dd)
         (command "imageclip" "l" "n" "r" f1 f3)
         (setq en1 (entlast))
         (command "circle" cen cir)
         (setq en2 (entlast))
         (command "block" c cen en2 en1 "")
         (setq centers (cons cen centers))
         (setq areal (cons areain areal))
         (setq f1 (polar f1 0 wh))
         (setq f2 (polar f1 0 wh))
         (setq f3 (polar f2 (/ pi 2) wv))
         (setq f4 (polar f3 pi wh))
         (setq cen (inters f1 f3 f2 f4))
         (setq areain (list (car f1) (car f3) (cadr f1) (cadr f3)))
         (setq nx (+ nx 1))
         (setq c (+ c 1))
      )
      (setq f1 (polar pivot (/ pi 2) (* wv ny)))
      (setq f2 (polar f1 0 wh))
      (setq f3 (polar f2 (/ pi 2) wv))
      (setq f4 (polar f3 pi wh))
      (setq cen (inters f1 f3 f2 f4))
      (setq areain (list (car f1) (car f3) (cadr f1) (cadr f3)))
      (setq ny (+ ny 1))
      (setq nx 0)
   )
   (setq c 0)
   (repeat (* div div)
      (command "insert" (+ 1 c) (nth c centers) "" "" "")
      (if (= (+ c 1) div)
         (command "erase" "l" "")
      )
      (setq c (+ 1 c))
   )
   (setq pv1 (polar pivot (* 1.5 pi) cir))
   (setq pv2 (polar pv1 pi (- (/ wh 2) cir)))
   (setq pv3 (polar pv2 0 (+ dhor (* (- (/ wh 2) cir) 2))))
   (setq pv4 (polar pv3 (/ pi 2) (+ dver (* cir 2))))
   (command "rectangle" pv2 pv4)
   (command "zoom" pv2 pv4)
   (setq areal (cons (list -10000 10000 -10000 10000) areal))
   (alert
      (strcat
         "\n To move a tile, select a tile adjacent\n to an open space."
         "\n\n Zoom out with scroll botton to view full picture"
         "\n\n Lower right tile removed."
      )
   )
   (setq moves 0)
   (command "imageframe" "off")
   (command "osmode" "0")
   (setq centers (reverse centers))
   (setq areal (reverse areal))
   (setq cont 0)
   (while (= cont 0)
      (setq ip (getpoint (strcat "\nSelect tile:  Total moves:  "
                                 (rtos moves 2 0)
                                 "    Press <Enter> to finish game."
                         )
               )
      )
      (if (= ip nil)
         (progn
            (command "imageframe" "on")
            (command "highlight" "1")
            (alert
               (strcat
                  "Game finished.\n\n To make another puzzle, you must erase"
                  "\n entire puzzle and purge drawing"
               )
            )
            (quit)
         )
      )
      (command "zoom" pv2 pv4)
      (setq flag 0)
      (setq ct 0)
      (while (= flag 0)
;;;;;;;;;;;;;;;
         (setq wpt (nth ct areal))
         (if (and (> (car ip) (nth 0 wpt))
                  (< (car ip) (nth 1 wpt))
                  (> (cadr ip) (nth 2 wpt))
                  (< (cadr ip) (nth 3 wpt))
             )
            (setq flag 1)
         )
         (setq ct (+ ct 1))
      )
      (if (<= ct (length centers))
         (progn
            (setq wcen (nth (- ct 1) centers))
            (setq dob1 (* cir 1.1))
            (setq dob2 (* cir 0.9))
            (setq obp1 (polar wcen 0 dob1))
            (setq obp2 (polar wcen 0 dob2))
            (setq sell (list obp1 obp2))
            (setq lat (- wh cir))
            (setq lat1 (* lat 1.1))
            (setq lat2 (* lat 0.9))
            (setq par (- wv cir))
            (setq par1 (* par 1.1))
            (setq par2 (* par 0.9))
            (setq up1 (polar wcen (/ pi 2) par2))
            (setq up2 (polar wcen (/ pi 2) par1))
            (setq rg1 (polar wcen 0 lat2))
            (setq rg2 (polar wcen 0 lat1))
            (setq dw1 (polar wcen (* 1.5 pi) par2))
            (setq dw2 (polar wcen (* 1.5 pi) par1))
            (setq lf1 (polar wcen pi lat2))
            (setq lf2 (polar wcen pi lat1))
            (setq lisup (list up1 up2))
            (setq lisrg (list rg1 rg2))
            (setq lisdw (list dw1 dw2))
            (setq lislf (list lf1 lf2))
            (setq up (ssget "_F" lisup))
            (setq rg (ssget "_F" lisrg))
            (setq dw (ssget "_F" lisdw))
            (setq lf (ssget "_F" lislf))
            (setq updis (strcat "@0," (rtos wv 2 6) ",0"))
            (setq rgdis (strcat "@" (rtos wh 2 6) ",0,0"))
            (setq dwdis (strcat "@0,-" (rtos wv 2 6) ",0"))
            (setq lfdis (strcat "@-" (rtos wh 2 6) ",0,0"))
            (if (= up nil)
               (progn (setq moves (+ moves 1))
                      (command "move" "f" obp1 obp2 "" "" "0,0,0" updis)
               )
            )
            (if (= rg nil)
               (progn (setq moves (+ moves 1))
                      (command "move" "f" obp1 obp2 "" "" "0,0,0" rgdis)
               )
            )
            (if (= dw nil)
               (progn (setq moves (+ moves 1))
                      (command "move" "f" obp1 obp2 "" "" "0,0,0" dwdis)
               )
            )
            (if (= lf nil)
               (progn (setq moves (+ moves 1))
                      (command "move" "f" obp1 obp2 "" "" "0,0,0" lfdis)
               )
            )
         )
      )
   )
   (command "undo" "e")
)


 ;|Visual LISP Format Options
(72 3 3 2 nil "end of " 60 9 0 0 0 nil nil nil T)
;*** DO NOT add text below the comment! ***|;
