;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;                                        
;;; lisp roulette    by Paul Silva, july 2006 San Diego California


;;; any suggestion or comments to the game, let me know at wpaulsilva@hotmail.com
;;; suggestions for other games welcome
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun c:play ()
  (command "highlight" "0")
  (command "cmdecho" "0")
  (command "osmode" "0")
  (command "blipmode" "off")
  (command "cursorsize" "2")
  (command "_layer" "on" "place" "")
  (command "_view" "r" "v1")
  (setq stop 1)
  (getorbalance)
  (clear)
  (setq textsize "0.11")  
  (setq den 5)    
  (if (= new nil)
    (progn
      (firstnotice)
      (alldata)
      (setq den 5)
    )
  )
  (setq new 1)
  (setq cont 0)
  (command "clayer" "bet")

  (while (= cont 0)
    (getbalance)    
    (setq ip
           (getpoint
             (strcat
               "\n Enter Bet:   Chip value: $ "
               (rtos den 2 0)
               " - Press <ENTER> or click [SPIN] to play."
             )
           )
    )
    (if (= stop 0)
      (setq ip nil)
    )
    (if (= ip nil)                      ; this is when pressing <ENTER>  to make spin automatically
      (setq ip (list 5.25 -2.25 0))
    )   

    (setq wlist arealim)
    (setq flag 0)
    (setq ct 0)
    (while (= flag 0)
      (setq wpt (nth ct wlist))
      (if (and (> (car ip) (nth 0 wpt))
               (< (car ip) (nth 1 wpt))
               (> (cadr ip) (nth 2 wpt))
               (< (cadr ip) (nth 3 wpt))
          )
        (setq flag 1)
      )
      (setq ct (+ ct 1))
    )
    (if (< balance den)
      (progn
        (setq ip nil)
        (setq den balance)
        (setq stop 0)

      )
    )

    (if (<= ct 154)
      (progn
        (setq wcc centers)
        (setq wcen (nth (- ct 1) wcc))
        (setq chip1 (polar wcen pi 0.1))
        (setq chip2 (polar wcen 0 0.1))
        (setq chipl (list chip1 chip2))
        (setq bb (ssget "_F" chipl '((8 . "bet"))))
        (if (/= bb nil)
          (progn
            (setq qty (cdr (assoc 1 (entget (ssname bb 0)))))
            (mtr qty)
            (command "erase" (ssname bb 0) "")
            (setq qty (+ den qty))
          )
          (setq qty den)
        )
        (rtm qty)
        (command "text" "J" "mc" wcen textsize "0" num)
        (update)
      )
    )

    (if (= ct 155)
      (setq den 5)                      ; this are the denominations $5
    )
    (if (= ct 156)
      (setq den 25)                     ;$25
    )
    (if (= ct 157)
      (setq den 50)                     ;$50
    )
    (if (= ct 158)
      (setq den 100)                    ;$100
    )
    (if (= ct 159)
      (setq den 500)                    ;$500
    )
    

    
    (if (= ct 160)                      ;spin button
      (progn
        (command "_view" "r" "v1")
        (command "_layer" "off" "place" "")
        (getbetdata)
        (spin)
        (money)
        (command "delay" "2000")
        (command "_layer" "off" "wait" "")
        (pay)
        (setq cont 1)
        (getbalance)
        (if (= balance 0)
          (alert " GAME OVER\n Type restart to reset your balance"))
      )
    )    

    (if (= ct 161)
      (alert
        (strcat
          "\n AREA NOT VALID!!\n\n PLACE BET OR \n Select [SPIN] \n\nCHIP VALUE:  $ "
          (rtos den 2 0)
        )

      )
    )
  )
  (princ)
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun rtm (a)                          ; real number to money annotation   1234  ->  $1,234
  (setq num a)
  (setq num (fix num))
  (setq num (rtos num 2 0))
  (setq len (strlen num))
  (if (or (= len 1) (= len 2) (= len 3))
    (setq num (strcat "$" num))
  )
  (if (= len 4)
    (progn
      (setq mil (substr num 2 3))
      (setq prim (substr num 1 1))
      (setq num (strcat "$" prim "," mil))
    )
  )
  (if (= len 5)
    (progn
      (setq mil (substr num 1 2))
      (setq prim (substr num 3 3))
      (setq num (strcat "$" mil "," prim))
    )
  )
  (if (= len 6)
    (progn
      (setq mil (substr num 1 3))
      (setq prim (substr num 4 3))
      (setq num (strcat "$" mil "," prim))
    )
  )
)

(defun mtr (b / num len mil prim)       ; money annotation to integer   $1,234  ->  1234

  (setq num b)
  (setq len (strlen num))
  (if (= len 2)
    (setq num (substr num 2 1))
  )
  (if (= len 3)
    (setq num (substr num 2 2))
  )
  (if (= len 4)
    (setq num (substr num 2 3))
  )
  (if (= len 6)
    (progn
      (setq mil (substr num 2 1))
      (setq prim (substr num 4 3))
      (setq num (strcat mil prim))
    )
  )
  (if (= len 7)
    (progn
      (setq mil (substr num 2 2))
      (setq prim (substr num 5 3))
      (setq num (strcat mil prim))
    )
  )
  (if (= len 8)
    (progn
      (setq mil (substr num 2 3))
      (setq prim (substr num 6 3))
      (setq num (strcat mil prim))
    )
  )
  (setq qty (atoi num))
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(defun u11 ()                           ;update balance and bet   *********************
  (setq p1bal (list 8.0 -2.0 0.0))
  (setq p2bal (list 10.0 -2.0 0.0))
  (setq libal (list p1bal p2bal))

  (setq getbal (ssget "_F" libal))
  (setq terase getbal)

  (setq getbal (cdr (assoc 1 (entget (ssname getbal 0)))))
  (mtr getbal)
  (command "erase" (ssname terase 0) "")
  (setq qty (- qty den))
  (rtm qty)
  (command "text" "J" "mc" (list 9.0 -2.0 0.0) "0.28" "0" num)
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(defun getbetdata (/ ss)                ;get all bet data
  (setq ss (ssget "X" '((8 . "bet"))))
  (if (= ss nil)
    (progn
      (alert "\n You don't have any bets. \n Game cancelled.")
      (exit)
    )
  )
  (setq betlist nil)
  (setq betct (sslength ss))
  (setq m 0)
  (setq grandbet 0)
  (while (< m betct)
    (setq workent (ssname ss m))
    (setq blocki (entget workent))
    (setq val (cdr (assoc 1 blocki)))
    (setq tmletter (strlen val))
    (setq betp (cdr (assoc 10 blocki)))
    (setq uppt (polar betp (/ pi 2) 0.05))
    (setq betp (polar uppt 0 (* (/ tmletter 2) 0.08)))
    (setq betq (mtr val))
    (setq grandbet (+ betq grandbet))
    (setq ip betp)
    (setq wlist arealim)
    (setq flag 0)
    (setq ct 0)
    (while (= flag 0)
      (setq wpt (nth ct wlist))
      (if (and (> (car ip) (nth 0 wpt))
               (< (car ip) (nth 1 wpt))
               (> (cadr ip) (nth 2 wpt))
               (< (cadr ip) (nth 3 wpt))
          )
        (setq flag 1)
      )
      (setq ct (+ ct 1))
    )
    (setq betp ct)
    (setq betdata (list betp betq))
    (setq betlist (cons betdata betlist))
    (setq m (+ m 1))
  )

)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun money ()
  (setq tbets (length betlist))
  (setq twin 0)
  (setq cc 0)
  (setq paid 0)
  (command "osmode" "0")
  (command "clayer" "winplace")
  (while (< cc tbets)
    (setq betp (nth 0 (nth cc betlist)))
    (setq betq (nth 1 (nth cc betlist)))

    (if (and (>= betp 1) (<= betp 38))  ;straight
      (if (= betp winn)
        (progn
          (command "insert" "dot" (nth (- betp 1) centers) "" "" "")
          (setq twin (+ (* 35 betq) betq))
        )
        (setq twin 0)
      )
    )
    (if (and (>= betp 39) (<= betp 95)) ;split
      (if (/= (member winn (nth (- betp 38) pays)) nil)
        (progn
          (command "insert" "dot" (nth (- betp 1) centers) "" "" "")
          (setq twin (+ (* 17 betq) betq))
        )
        (setq twin 0)
      )
    )
    (if (and (>= betp 96) (<= betp 117)) ; corner
      (if (/= (member winn (nth (- betp 38) pays)) nil)
        (progn
          (command "insert" "dot" (nth (- betp 1) centers) "" "" "")
          (setq twin (+ (* 8 betq) betq))
        )
        (setq twin 0)
      )
    )
    (if (and (>= betp 118) (<= betp 129)) ; street
      (if (/= (member winn (nth (- betp 38) pays)) nil)
        (progn
          (command "insert" "dot" (nth (- betp 1) centers) "" "" "")
          (setq twin (+ (* 11 betq) betq))
        )
        (setq twin 0)
      )
    )
    (if (and (>= betp 130) (<= betp 140)) ; line
      (if (/= (member winn (nth (- betp 38) pays)) nil)
        (progn
          (command "insert" "dot" (nth (- betp 1) centers) "" "" "")
          (setq twin (+ (* 5 betq) betq))
        )
        (setq twin 0)
      )
    )
    (if (and (>= betp 141) (<= betp 142)) ; trio
      (if (/= (member winn (nth (- betp 38) pays)) nil)
        (progn
          (command "insert" "dot" (nth (- betp 1) centers) "" "" "")
          (setq twin (+ (* 6 betq) betq))
        )
        (setq twin 0)
      )
    )
    (if (and (>= betp 143) (<= betp 148)) ; col dozen
      (if (/= (member winn (nth (- betp 38) pays)) nil)
        (progn
          (command "insert" "dot" (nth (- betp 1) centers) "" "" "")
          (setq twin (+ (* 2 betq) betq))
        )
        (setq twin 0)
      )
    )
    (if (and (>= betp 149) (<= betp 154)) ; high even red black odd low
      (if (/= (member winn (nth (- betp 38) pays)) nil)
        (progn
          (command "insert" "dot" (nth (- betp 1) centers) "" "" "")
          (setq twin (+ (* 1 betq) betq))
        )
        (setq twin 0)
      )
    )
    (setq paid (+ paid twin))
    (setq cc (+ cc 1))
  )
  (rtm grandbet)
  (setq totalbet num)
  (rtm paid)
  (setq tpaid num)
  (command "_layer" "on" "wait" "")                 

)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun clear ()                         ;get all bet data

  (setq clearss (ssget
                  "X"
                  '((8 . "bet"))
                )
  )
  (command "erase" clearss "")
  (setq clearwp (ssget
                  "X"
                  '((8 . "winplace"))
                )
  )
  (command "erase" clearwp "")
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;  SPIN  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun spin ()

  (command "undo" "g")
  (command "_view" "r" "v1")
  (command "_layer" "on" "luck" "")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; there are 3 parameters to consider for spin of wheel,
;;; first there is a random number from (1 - 10)  + 5 that would be the initial angle for wheel
;;; the second is a random number from (1 - 20 ) + 15 being the initial angle for ball
;;; both angles are repeatedly multiplied by 0.985 & 0.94 respectively times a random number from
;;; (1 - 40) + 120 -> tspin
;;; each time the wheel is spun, all 3 parameters are different.  making the wheel stop suddenly or
;;; stop more slowly at times, in addition the ball rotates the opposite direction of the wheel.
;;; the winning number cannot be know until the wheel and ball stop spinning

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  (setq addang (* (rn) 10))
  (setq ang (+ 5.0 addang))
  (setq addangb (* (rn) 20))
  (setq angb (+ 15.0 addangb))
  (setq tspin (* (rn) 40))
  (setq tspin (+ 120 tspin))              
  (setq n 0)
  (setq ss (ssget "X" '((8 . "WHEEL"))))
  (setq xx (ssget "X" '((8 . "BALL"))))
  (while (< n tspin)
    (setq ballobj (ssname xx 0))
    (setq ballent (entget ballobj))
    (setq workobj (ssname ss 0))
    (setq workent (entget workobj))
    (setq wcen (cdr (assoc 10 workent)))
    (command "rotate" workobj "" wcen ang)
    (command "rotate" ballobj "" wcen (* -1 angb))
    (setq angb (* angb 0.94))
    (setq ang (* ang 0.985))
    (setq n (+ 1 n))
  )

  (setq fanw (cdr (assoc 50 (entget workobj))))
  (setq fanb (angle wcen (cdr (assoc 10 (entget ballobj)))))
  (if (> fanb fanw)
    (setq target (- fanb fanw))
  )
  (if (> fanw fanb)
    (setq target (- (+ (* 2 pi) fanb) fanw))
  )
  (setq winn (nth (fix (/ target (/ (* 2 pi) 38))) placewheel))
  
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; target & search variables depend on the results by the spin function,
;;; once a search variable is established, it is look on the -placewheel- variable for the
;;; sequential order in which the numbers are placed around the wheel.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  (command "erase"
           "f"
           (list -2.4 3.3 0)
           (list -1.7 3.3 0)
           ""
           ""
  )
  (command "clayer" "history")
  (setq historysel
         (ssget "_C"
                '(-1.5 3.75 0)
                '(-2.65 -6 0)
                '((8 . "history"))
         )
  )
  (if (/= historysel nil)
    (command "move" historysel "" "0,0,0" "@0,0.5,0")
  )
  (setq hisz 0.322)
  (if (<= winn 36)
    (setq num (itoa winn))
  )
  (if (= winn 37)
    (setq num "0")
  )
  (if (= winn 38)
    (setq num "00")
  )
  (command "text"
           "s"
           "Standard"
           "j"
           "mc"
           (list -2.13 -5.7 0)
           hisz
           "0"
           num
  )
  (if (or (= winn 1)
          (= winn 3)
          (= winn 5)
          (= winn 7)
          (= winn 9)
          (= winn 12)
          (= winn 14)
          (= winn 16)
          (= winn 18)
          (= winn 19)
          (= winn 21)
          (= winn 23)
          (= winn 25)
          (= winn 27)
          (= winn 30)
          (= winn 32)
          (= winn 34)
          (= winn 36)
      )
    (command "change" "l" "" "p" "c" "1" "")
    (command "change" "l" "" "p" "c" "2" "")
  )
  (if (or (= winn 37) (= winn 38))
    (command "change" "l" "" "p" "c" "3" "")
  )
  (command "_layer" "off" "luck" "")
  (command "clayer" "winplace")
  (command "insert"
           "winchip"
           (nth (- winn 1) centers)
           ""
           ""
           ""
  )
  (command "undo" "e")
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun rn ()
  (if (not sd)
    (setq sd (getvar "DATE"))
  )
  (setq md 65536
        mx 25173
        nc 13849
        sd (rem (+ (* mx sd) nc) md)
  )
  (setq nx (/ sd md))
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun alldata ()                       ;arealim by number  

  (setq arealim (list (list 0.000 0.850 0.000 1.100) ;1
                      (list 0.000 0.850 1.400 2.350) ;2
                      (list 0.000 0.850 2.650 3.600) ;3
                      (list 1.150 1.850 0.000 1.100) ;4
                      (list 1.150 1.850 1.400 2.350) ;5
                      (list 1.150 1.850 2.650 3.600) ;6
                      (list 2.150 2.850 0.000 1.100) ;7
                      (list 2.150 2.850 1.400 2.350) ;8
                      (list 2.150 2.850 2.650 3.600) ;9
                      (list 3.150 3.850 0.000 1.100) ;10
                      (list 3.150 3.850 1.400 2.350) ;11
                      (list 3.150 3.850 2.650 3.600) ;12
                      (list 4.150 4.850 0.000 1.100) ;13
                      (list 4.150 4.850 1.400 2.350) ;14
                      (list 4.150 4.850 2.650 3.600) ;15
                      (list 5.150 5.850 0.000 1.100) ;16
                      (list 5.150 5.850 1.400 2.350) ;17
                      (list 5.150 5.850 2.650 3.600) ;18
                      (list 6.150 6.850 0.000 1.100) ;19
                      (list 6.150 6.850 1.400 2.350) ;20
                      (list 6.150 6.850 2.650 3.600) ;21
                      (list 7.150 7.850 0.000 1.100) ;22
                      (list 7.150 7.850 1.400 2.350) ;23
                      (list 7.150 7.850 2.650 3.600) ;24
                      (list 8.150 8.850 0.000 1.100) ;25
                      (list 8.150 8.850 1.400 2.350) ;26
                      (list 8.150 8.850 2.650 3.600) ;27
                      (list 9.150 9.850 0.000 1.100) ;28
                      (list 9.150 9.850 1.400 2.350) ;29
                      (list 9.150 9.850 2.650 3.600) ;30
                      (list 10.150 10.850 0.000 1.100) ;31
                      (list 10.150 10.850 1.400 2.350) ;32
                      (list 10.150 10.850 2.650 3.600) ;33
                      (list 11.150 12.000 0.000 1.100) ;34
                      (list 11.150 12.000 1.400 2.350) ;35
                      (list 11.150 12.000 2.650 3.600) ;36
                      (list -1.050 0.000 0.000 1.725) ;37
                      (list -1.050 0.000 2.025 3.600) ;38
                      (list 0.850 1.150 0.000 1.100) ;39
                      (list 1.850 2.150 0.000 1.100) ;40
                      (list 2.850 3.150 0.000 1.100) ;41
                      (list 3.850 4.150 0.000 1.100) ;42
                      (list 4.850 5.150 0.000 1.100) ;43
                      (list 5.850 6.150 0.000 1.100) ;44
                      (list 6.850 7.150 0.000 1.100) ;45
                      (list 7.850 8.150 0.000 1.100) ;46
                      (list 8.850 9.150 0.000 1.100) ;47
                      (list 9.850 10.150 0.000 1.100) ;48
                      (list 10.850 11.150 0.000 1.100) ;49
                      (list 0.000 0.850 1.100 1.400) ;50
                      (list 1.150 1.850 1.100 1.400) ;51
                      (list 2.150 2.850 1.100 1.400) ;52
                      (list 3.150 3.850 1.100 1.400) ;53
                      (list 4.150 4.850 1.100 1.400) ;54
                      (list 5.150 5.850 1.100 1.400) ;55
                      (list 6.150 6.850 1.100 1.400) ;56
                      (list 7.150 7.850 1.100 1.400) ;57
                      (list 8.150 8.850 1.100 1.400) ;58
                      (list 9.150 9.850 1.100 1.400) ;59
                      (list 10.150 10.850 1.100 1.400) ;60
                      (list 11.150 12.000 1.100 1.400) ;61
                      (list 0.850 1.150 1.400 2.350) ;62
                      (list 1.850 2.150 1.400 2.350) ;63
                      (list 2.850 3.150 1.400 2.350) ;64
                      (list 3.850 4.150 1.400 2.350) ;65
                      (list 4.850 5.150 1.400 2.350) ;66
                      (list 5.850 6.150 1.400 2.350) ;67
                      (list 6.850 7.150 1.400 2.350) ;68
                      (list 7.850 8.150 1.400 2.350) ;69
                      (list 8.850 9.150 1.400 2.350) ;70
                      (list 9.850 10.150 1.400 2.350) ;71
                      (list 10.850 11.150 1.400 2.350) ;72
                      (list 0.000 0.850 2.350 2.650) ;73
                      (list 1.150 1.850 2.350 2.650) ;74
                      (list 2.150 2.850 2.350 2.650) ;75
                      (list 3.150 3.850 2.350 2.650) ;76
                      (list 4.150 4.850 2.350 2.650) ;77
                      (list 5.150 5.850 2.350 2.650) ;78
                      (list 6.150 6.850 2.350 2.650) ;79
                      (list 7.150 7.850 2.350 2.650) ;80
                      (list 8.150 8.850 2.350 2.650) ;81
                      (list 9.150 9.850 2.350 2.650) ;82
                      (list 10.150 10.850 2.350 2.650) ;83
                      (list 11.150 12.000 2.350 2.650) ;84
                      (list 0.850 1.150 2.650 3.600) ;85
                      (list 1.850 2.150 2.650 3.600) ;86
                      (list 2.850 3.150 2.650 3.600) ;87
                      (list 3.850 4.150 2.650 3.600) ;88
                      (list 4.850 5.150 2.650 3.600) ;89
                      (list 5.850 6.150 2.650 3.600) ;90
                      (list 6.850 7.150 2.650 3.600) ;91
                      (list 7.850 8.150 2.650 3.600) ;92
                      (list 8.850 9.150 2.650 3.600) ;93
                      (list 9.850 10.150 2.650 3.600) ;94
                      (list 10.850 11.150 2.650 3.600) ;95
                      (list 0.850 1.150 1.100 1.400) ;96
                      (list 1.850 2.150 1.100 1.400) ;97
                      (list 2.850 3.150 1.100 1.400) ;98
                      (list 3.850 4.150 1.100 1.400) ;99
                      (list 4.850 5.150 1.100 1.400) ;100
                      (list 5.850 6.150 1.100 1.400) ;101
                      (list 6.850 7.150 1.100 1.400) ;102
                      (list 7.850 8.150 1.100 1.400) ;103
                      (list 8.850 9.150 1.100 1.400) ;104
                      (list 9.850 10.150 1.100 1.400) ;105
                      (list 10.850 11.150 1.100 1.400) ;106
                      (list 0.850 1.150 2.350 2.650) ;107
                      (list 1.850 2.150 2.350 2.650) ;108
                      (list 2.850 3.150 2.350 2.650) ;109
                      (list 3.850 4.150 2.350 2.650) ;110
                      (list 4.850 5.150 2.350 2.650) ;111
                      (list 5.850 6.150 2.350 2.650) ;112
                      (list 6.850 7.150 2.350 2.650) ;113
                      (list 7.850 8.150 2.350 2.650) ;114
                      (list 8.850 9.150 2.350 2.650) ;115
                      (list 9.850 10.150 2.350 2.650) ;116
                      (list 10.850 11.150 2.350 2.650) ;117
                      (list 0.000 0.850 3.600 3.900) ;118
                      (list 1.150 1.850 3.600 3.900) ;119
                      (list 2.150 2.850 3.600 3.900) ;120
                      (list 3.150 3.850 3.600 3.900) ;121
                      (list 4.150 4.850 3.600 3.900) ;122
                      (list 5.150 5.850 3.600 3.900) ;123
                      (list 6.150 6.850 3.600 3.900) ;124
                      (list 7.150 7.850 3.600 3.900) ;125
                      (list 8.150 8.850 3.600 3.900) ;126
                      (list 9.150 9.850 3.600 3.900) ;127
                      (list 10.150 10.850 3.600 3.900) ;128
                      (list 11.150 12.000 3.600 3.900) ;129
                      (list 0.850 1.150 3.600 3.900) ;130
                      (list 1.850 2.150 3.600 3.900) ;131
                      (list 2.850 3.150 3.600 3.900) ;132
                      (list 3.850 4.150 3.600 3.900) ;133
                      (list 4.850 5.150 3.600 3.900) ;134
                      (list 5.850 6.150 3.600 3.900) ;135
                      (list 6.850 7.150 3.600 3.900) ;136
                      (list 7.850 8.150 3.600 3.900) ;137
                      (list 8.850 9.150 3.600 3.900) ;138
                      (list 9.850 10.150 3.600 3.900) ;139
                      (list 10.850 11.150 3.600 3.900) ;140
                      (list -1.050 0.000 1.725 2.025) ;141
                      (list -1.050 0.000 3.600 3.900) ;142
                      (list 12.000 13.050 2.500 3.750) ;143
                      (list 12.000 13.050 1.250 2.500) ;144
                      (list 12.000 13.050 0.000 1.250) ;145
                      (list 0.000 4.000 -0.750 0.000) ;146
                      (list 4.000 8.000 -0.750 0.000) ;147
                      (list 8.000 12.000 -0.750 0.000) ;148
                      (list 0.000 2.000 -1.550 -0.750) ;149
                      (list 2.000 4.000 -1.550 -0.750) ;150
                      (list 4.000 6.000 -1.550 -0.750) ;151
                      (list 6.000 8.000 -1.550 -0.750) ;152
                      (list 8.000 10.000 -1.550 -0.750) ;153
                      (list 10.000 12.000 -1.550 -0.750) ;154
                      (list 6.500 7.500 -2.500 -2.000) ;155
                      (list 7.500 8.500 -2.500 -2.000) ;156
                      (list 8.500 9.500 -2.500 -2.000) ;157
                      (list 9.500 10.750 -2.500 -2.000) ;158
                      (list 10.750 12.000 -2.500 -2.000) ;159
                      (list 4.500 6.000 -3.000 -2.000) ;160
                      (list -1000.00 1000.00 -1000.00 1000.00)
                                        ;161  open area test
                )
  )
  ;;  center of boxes  1 - 154
  (setq centers (list
                  (list 0.500 0.350 0.000) ;1
                  (list 0.500 1.600 0.000) ;2
                  (list 0.500 2.850 0.000) ;3
                  (list 1.500 0.350 0.000) ;4
                  (list 1.500 1.600 0.000) ;5
                  (list 1.500 2.850 0.000) ;6
                  (list 2.500 0.350 0.000) ;7
                  (list 2.500 1.600 0.000) ;8
                  (list 2.500 2.850 0.000) ;9
                  (list 3.500 0.350 0.000) ;10
                  (list 3.500 1.600 0.000) ;11
                  (list 3.500 2.850 0.000) ;12
                  (list 4.500 0.350 0.000) ;13
                  (list 4.500 1.600 0.000) ;14
                  (list 4.500 2.850 0.000) ;15
                  (list 5.500 0.350 0.000) ;16
                  (list 5.500 1.600 0.000) ;17
                  (list 5.500 2.850 0.000) ;18
                  (list 6.500 0.350 0.000) ;19
                  (list 6.500 1.600 0.000) ;20
                  (list 6.500 2.850 0.000) ;21
                  (list 7.500 0.350 0.000) ;22
                  (list 7.500 1.600 0.000) ;23
                  (list 7.500 2.850 0.000) ;24
                  (list 8.500 0.350 0.000) ;25
                  (list 8.500 1.600 0.000) ;26
                  (list 8.500 2.850 0.000) ;27
                  (list 9.500 0.350 0.000) ;28
                  (list 9.500 1.600 0.000) ;29
                  (list 9.500 2.850 0.000) ;30
                  (list 10.500 0.350 0.000) ;31
                  (list 10.500 1.600 0.000) ;32
                  (list 10.500 2.850 0.000) ;33
                  (list 11.500 0.350 0.000) ;34
                  (list 11.500 1.600 0.000) ;35
                  (list 11.500 2.850 0.000) ;36
                  (list -0.525 0.392 0.000) ;37
                  (list -0.525 2.267 0.000) ;38
                  (list 1.000 0.550 0.000) ;39
                  (list 2.000 0.550 0.000) ;40
                  (list 3.000 0.550 0.000) ;41
                  (list 4.000 0.550 0.000) ;42
                  (list 5.000 0.550 0.000) ;43
                  (list 6.000 0.550 0.000) ;44
                  (list 7.000 0.550 0.000) ;45
                  (list 8.000 0.550 0.000) ;46
                  (list 9.000 0.550 0.000) ;47
                  (list 10.000 0.550 0.000) ;48
                  (list 11.000 0.550 0.000) ;49
                  (list 0.425 1.250 0.000) ;50
                  (list 1.500 1.250 0.000) ;51
                  (list 2.500 1.250 0.000) ;52
                  (list 3.500 1.250 0.000) ;53
                  (list 4.500 1.250 0.000) ;54
                  (list 5.500 1.250 0.000) ;55
                  (list 6.500 1.250 0.000) ;56
                  (list 7.500 1.250 0.000) ;57
                  (list 8.500 1.250 0.000) ;58
                  (list 9.500 1.250 0.000) ;59
                  (list 10.500 1.250 0.000) ;60
                  (list 11.575 1.250 0.000) ;61
                  (list 1.000 1.875 0.000) ;62
                  (list 2.000 1.875 0.000) ;63
                  (list 3.000 1.875 0.000) ;64
                  (list 4.000 1.875 0.000) ;65
                  (list 5.000 1.875 0.000) ;66
                  (list 6.000 1.875 0.000) ;67
                  (list 7.000 1.875 0.000) ;68
                  (list 8.000 1.875 0.000) ;69
                  (list 9.000 1.875 0.000) ;70
                  (list 10.000 1.875 0.000) ;71
                  (list 11.000 1.875 0.000) ;72
                  (list 0.425 2.500 0.000) ;73
                  (list 1.500 2.500 0.000) ;74
                  (list 2.500 2.500 0.000) ;75
                  (list 3.500 2.500 0.000) ;76
                  (list 4.500 2.500 0.000) ;77
                  (list 5.500 2.500 0.000) ;78
                  (list 6.500 2.500 0.000) ;79
                  (list 7.500 2.500 0.000) ;80
                  (list 8.500 2.500 0.000) ;81
                  (list 9.500 2.500 0.000) ;82
                  (list 10.500 2.500 0.000) ;83
                  (list 11.575 2.500 0.000) ;84
                  (list 1.000 3.125 0.000) ;85
                  (list 2.000 3.125 0.000) ;86
                  (list 3.000 3.125 0.000) ;87
                  (list 4.000 3.125 0.000) ;88
                  (list 5.000 3.125 0.000) ;89
                  (list 6.000 3.125 0.000) ;90
                  (list 7.000 3.125 0.000) ;91
                  (list 8.000 3.125 0.000) ;92
                  (list 9.000 3.125 0.000) ;93
                  (list 10.000 3.125 0.000) ;94
                  (list 11.000 3.125 0.000) ;95
                  (list 1.000 1.250 0.000) ;96
                  (list 2.000 1.250 0.000) ;97
                  (list 3.000 1.250 0.000) ;98
                  (list 4.000 1.250 0.000) ;99
                  (list 5.000 1.250 0.000) ;100
                  (list 6.000 1.250 0.000) ;101
                  (list 7.000 1.250 0.000) ;102
                  (list 8.000 1.250 0.000) ;103
                  (list 9.000 1.250 0.000) ;104
                  (list 10.000 1.250 0.000) ;105
                  (list 11.000 1.250 0.000) ;106
                  (list 1.000 2.500 0.000) ;107
                  (list 2.000 2.500 0.000) ;108
                  (list 3.000 2.500 0.000) ;109
                  (list 4.000 2.500 0.000) ;110
                  (list 5.000 2.500 0.000) ;111
                  (list 6.000 2.500 0.000) ;112
                  (list 7.000 2.500 0.000) ;113
                  (list 8.000 2.500 0.000) ;114
                  (list 9.000 2.500 0.000) ;115
                  (list 10.000 2.500 0.000) ;116
                  (list 11.000 2.500 0.000) ;117
                  (list 0.425 3.750 0.000) ;118
                  (list 1.500 3.750 0.000) ;119
                  (list 2.500 3.750 0.000) ;120
                  (list 3.500 3.750 0.000) ;121
                  (list 4.500 3.750 0.000) ;122
                  (list 5.500 3.750 0.000) ;123
                  (list 6.500 3.750 0.000) ;124
                  (list 7.500 3.750 0.000) ;125
                  (list 8.500 3.750 0.000) ;126
                  (list 9.500 3.750 0.000) ;127
                  (list 10.500 3.750 0.000) ;128
                  (list 11.575 3.750 0.000) ;129
                  (list 1.000 3.750 0.000) ;130
                  (list 2.000 3.750 0.000) ;131
                  (list 3.000 3.750 0.000) ;132
                  (list 4.000 3.750 0.000) ;133
                  (list 5.000 3.750 0.000) ;134
                  (list 6.000 3.750 0.000) ;135
                  (list 7.000 3.750 0.000) ;136
                  (list 8.000 3.750 0.000) ;137
                  (list 9.000 3.750 0.000) ;138
                  (list 10.000 3.750 0.000) ;139
                  (list 11.000 3.750 0.000) ;140
                  (list -0.525 1.875 0.000) ;141
                  (list -0.525 3.750 0.000) ;142
                  (list 12.525 2.981 0.000) ;143
                  (list 12.525 1.731 0.000) ;144
                  (list 12.525 0.481 0.000) ;145
                  (list 2.000 -0.500 0.000) ;146
                  (list 6.000 -0.500 0.000) ;147
                  (list 10.000 -0.500 0.000) ;148
                  (list 1.000 -1.300 0.000) ;149
                  (list 3.000 -1.300 0.000) ;150
                  (list 5.000 -1.150 0.000) ;151
                  (list 7.000 -1.150 0.000) ;152
                  (list 9.000 -1.300 0.000) ;153
                  (list 11.000 -1.300 0.000) ;154

                )
  )
  (setq pays
         (list
           (list 1   2   3   4   5   6   7   8   9   10  11  12  13
                 14  15  16  17  18  19  20  21  22  23  24  25  26
                 27  28  29  30  31  32  33  34  35  36  37  38
                )                       ; straight
           (list 1 4)                   ;split
           (list 4 7)
           (list 7 10)
           (list 10 13)
           (list 13 16)
           (list 16 19)
           (list 19 22)
           (list 22 25)
           (list 25 28)
           (list 28 31)
           (list 31 34)
           (list 1 2)
           (list 4 5)
           (list 7 8)
           (list 10 11)
           (list 13 14)
           (list 16 17)
           (list 19 20)
           (list 22 23)
           (list 25 26)
           (list 28 29)
           (list 31 32)
           (list 34 35)
           (list 2 5)
           (list 5 8)
           (list 8 11)
           (list 11 14)
           (list 14 17)
           (list 17 20)
           (list 20 23)
           (list 23 26)
           (list 26 29)
           (list 29 32)
           (list 32 35)
           (list 2 3)
           (list 5 6)
           (list 8 9)
           (list 11 12)
           (list 14 15)
           (list 17 18)
           (list 20 21)
           (list 23 24)
           (list 26 27)
           (list 29 30)
           (list 32 33)
           (list 35 36)
           (list 3 6)
           (list 6 9)
           (list 9 12)
           (list 12 15)
           (list 15 18)
           (list 18 21)
           (list 21 24)
           (list 24 27)
           (list 27 30)
           (list 30 33)
           (list 33 36)
           (list 1 2 4 5)               ;corner
           (list 4 5 7 8)
           (list 7 8 10 11)
           (list 10 11 13 14)
           (list 13 14 16 17)
           (list 16 17 19 20)
           (list 19 20 22 23)
           (list 22 23 25 26)
           (list 25 26 28 29)
           (list 28 29 31 32)
           (list 31 32 34 35)
           (list 2 3 5 6)
           (list 5 6 8 9)
           (list 8 9 11 12)
           (list 11 12 14 15)
           (list 14 15 17 18)
           (list 17 18 20 21)
           (list 20 21 23 24)
           (list 23 24 26 27)
           (list 26 27 29 30)
           (list 29 30 32 33)
           (list 32 33 35 36)
           (list 1 2 3)                 ;street
           (list 4 5 6)
           (list 7 8 9)
           (list 10 11 12)
           (list 13 14 15)
           (list 16 17 18)
           (list 19 20 21)
           (list 22 23 24)
           (list 25 26 27)
           (list 28 29 30)
           (list 31 32 33)
           (list 34 35 36)
           (list 1 2 3 4 5 6)           ;line
           (list 4 5 6 7 8 9)
           (list 7 8 9 10 11 12)
           (list 10 11 12 13 14 15)
           (list 13 14 15 16 17 18)
           (list 16 17 18 19 20 21)
           (list 19 20 21 22 23 24)
           (list 22 23 24 25 26 27)
           (list 25 26 27 28 29 30)
           (list 28 29 30 31 32 33)
           (list 31 32 33 34 35 36)
           (list 1 2 37)                ;trio
           (list 2 3 38)
           (list 3 6 9 12 15 18 21 24 27 30 33 36) ;col 1
           (list 2 5 8 11 14 17 20 23 26 29 32 35) ;col 2
           (list 1 4 7 10 13 16 19 22 25 28 31 34) ;col 3
           (list 1 2 3 4 5 6 7 8 9 10 11 12) ;dozen 1
           (list 13 14 15 16 17 18 19 20 21 22 23 24) ;dozen 2
           (list 25 26 27 28 29 30 31 32 33 34 35 36) ;dozen 3
           (list 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18) ;low
           (list 2 4 6 8 10 12 14 16 18 20 22 24 26 28 30 32 34 36)
                                        ;even
           (list 1 3 5 7 9 12 14 16 18 19 21 23 25 27 30 32 34 36) ;red
           (list 2 4 6 8 10 11 13 15 17 20 22 24 26 28 29 31 33 35)
                                        ;black
           (list 1 3 5 7 9 11 13 15 17 19 21 23 25 27 29 31 33 35) ;odd
           (list 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36)
                                        ;high
         )
  )

;;; this is the sequential order in which the numbers are placed around the wheel,
;;; it is understood that 37 -> 0    and  38 -> 00
  (setq placewheel
         (list 17  32  20  7   11  30  26  9   28  37  2   14  35  23
               4   16  33  21  6   18  31  19  8   12  29  25  10  27
               38  1   13  36  24  3   15  34  22  5
              )
  )

)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun firstnotice ()

  (alert
    (strcat
      "     * * * ROULETTE * * *                                 PEI @ Copyright. 2006"
      "\n------------------------------------------------------------------------------------------"
      "\n Indications:"
      "\n\nTo place your bet simply click on number desired,"
      "\nthe amount of your chip denomination value will be placed."
      "\n\nTo increase or decrease chip denomination, click on value."
      "\n Keep in mind to lower your chip denomination when having low balance"
      "\n Other wise next bet will be modified accordingly."
      "\n\n Once all bets are placed, click  [SPIN] or press <ENTER> to play."
      "\n Wait a few seconds to verify and display your results." "\n"
      "\n                                              Press OK to play."
      "\n------------------------------------------------------------------------------------------"
      "\n                                          G O O D    L U C K ! ! ! "
      "\n------------------------------------------------------------------------------------------")
  )
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun getbalance ()
  (setq balancesel (ssget "X" '((8 . "balance"))))
  (setq
    balance (cdr (assoc 1 (entget (ssname balancesel 0))))
  )
  (setq balance (mtr balance))
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun getorbalance ()
  (setq orbalancesel (ssget "X" '((8 . "balance"))))
  (setq
    orbalance (cdr (assoc 1 (entget (ssname orbalancesel 0))))
  )
  (setq orbalance (mtr orbalance))
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun c:restart ()
  (setq resbalss (ssget "X" '((8 . "balance"))))
  (setq origin (entget (ssname resbalss 0)))
  (setq balancereset "$2,000")
  (setq edb (entget (cdr (assoc -1 origin))))
  (setq edb (subst (cons 1 balancereset) (assoc 1 edb) edb))
  (entmod edb)

  (setq betsel (ssget "X" '((8 . "betl"))))
  (setq originbet (entget (ssname betsel 0)))
  (setq up "$0")
  (setq edt (entget (cdr (assoc -1 originbet))))
  (setq edt (subst (cons 1 up) (assoc 1 edt) edt))
  (entmod edt)
  (setq new nil)

)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun update ()

  (setq balancesel (ssget "X" '((8 . "balance"))))
  (setq cant den)
  (setq origin (entget (ssname balancesel 0)))
  (setq valuebal  (cdr (assoc 1 origin)))
  (mtr valuebal)
  (setq valuebal qty)
  (setq down (- valuebal cant))
   (rtm down )
  (setq down num)
  (setq edb (entget (cdr (assoc -1 origin))))
  (setq edb (subst (cons 1 down) (assoc 1 edb) edb))
  (entmod edb)

  (setq betsel (ssget "X" '((8 . "betl"))))
  (setq originbet (entget (ssname betsel 0)))
  (setq valuebet  (cdr (assoc 1 originbet)))
  (mtr valuebet)
  (setq valuebet qty)
  (setq up (+ valuebet den))
  (rtm up)
  (setq up num)
  (setq edbet (entget (cdr (assoc -1 originbet))))
  (setq edbet (subst (cons 1 up) (assoc 1 edbet) edbet))
  (entmod edbet)                                        
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun pay ()

  (setq balancesel (ssget "X" '((8 . "balance"))))
  (setq cant den)
  (setq origin (entget (ssname balancesel 0)))
  (setq valuebal (atoi (cdr (assoc 1 origin))))
  (if (> paid 0)

    (setq down (+ balance paid))
    (setq down balance)
  )
  (rtm down)
  (setq down num)
  
  (setq edb (entget (cdr (assoc -1 origin))))
  (setq edb (subst (cons 1 down) (assoc 1 edb) edb))
  (entmod edb)

  (setq betsel (ssget "X" '((8 . "betl"))))
  (setq originbet (entget (ssname betsel 0)))
  (setq up "$0")
  (setq edt (entget (cdr (assoc -1 originbet))))
  (setq edt (subst (cons 1 up) (assoc 1 edt) edt))
  (entmod edt)

                                          
)
;|Visual LISP Format Options
(72 2 40 2 nil "end of " 60 9 0 0 0 nil T nil T)
;*** DO NOT add text below the comment! ***|;
